#!/usr/bin/env python3
## COPYRIGHT Memento Cloud. Tous droits réservés 2021.

import subprocess
import sys
from pathlib import Path

def execCmd(iCmd: str, *args, **kwargs):
	print(iCmd)
	subprocess.run(iCmd, *args, check=True, executable="bash", shell=True, **kwargs)

kNomImage = "memento-cloud.fr/korus-install:latest"

print("Bienvenue dans la configuration de Korus pour plateforme Docker.")
print("================================================================\n")
print("Ce script configurera le dossier courant pour acceuillir une installation du logiciel de sauvegarde Korus via Docker.")
print("Si le dossier courant n'est pas adéquat, merci de créer un nouveau dossier et de copier les éléments de l'installateur dedans.")
print("En cas d'erreur, vous pouvez terminer le script avec 'CTRL + C' et le lancer à nouveau.")

print("ETAPE 1/2")
print("---------")
print("Import de l'image Docker. Il vous sera peut être demandé de fournir votre mdp sudo.")
lCmd = f"sudo echo 'Import en cours...' && cat ./Korus-Docker-*.img | sudo docker load"
execCmd(lCmd)
print("Import de l'image terminé avec succès.")


print("ETAPE 2/2")
print("---------")

print("Création d'un volume dans le dossier courant pour stocker les données de l'agent.")
lVol = Path("./volume")
lVol.mkdir(exist_ok=True)
print("Volume créé.")


print("Configuration de l'agent docker.")

print("Veuillez indiquer le nom de l'agent (utilisé pour identifier le conteneur) : ")
lNomAgent = input()

print("Veuillez copiez-coller le jeton d'installation : ")
lJeton = input()

print("Indiquez le chemin vers le fichier Trousseau.html (ou laissez vide pour utiliser un nouveau trousseau) : ")
lTrousseau = input()
lDestTrousseau = lVol / "Trousseau.html"
if lTrousseau:
	lCheminT = Path(lTrousseau)
	if not lCheminT.is_file():
		print(f"ERREUR : le fichier {lCheminT.as_posix()} n'existe pas. Abandon de la configuration.")
		sys.exit(1)
	execCmd(f"sudo rm -f '{lDestTrousseau.as_posix()}'")
	lDestTrousseau.write_text(lCheminT.read_text())
	execCmd(f"sudo chmod 600 '{lDestTrousseau.as_posix()}' && sudo chown root:root '{lDestTrousseau.as_posix()}'")
else:
	execCmd(f"sudo rm -f '{lDestTrousseau.as_posix()}'")
	print("Vous avez choisi de générer un nouveau Trousseau.")


print("Création des fichiers de configuration.")
lENV = f"NOM_KORUS={lNomAgent}\n"
lENV += "CHEM_VOL_STOCKAGE=./volume\n"
lENV += f"NOM_IMAGE={kNomImage}"

Path(".env").write_text(lENV)

lKorusEnv = f"MEMENTO_JETON_LIAISON={lJeton}\n"
Path("korus.env").write_text(lKorusEnv)

print("Fichiers de configuration créés.")

print("Configuration terminée.")
print("Vous pouvez controler l'agent avec les commandes suivantes (exécutées depuis ce dossier) :")
print("Lancement : 'sudo docker-compose --compatibility up --detach'")
print("Arrêt :     'sudo docker-compose --compatibility down'")
