#!/usr/bin/env python3
# COPYRIGHT Memento Cloud. Tous droits réservés 2022.

# Commandes de gestion du tarball :
# curl https://assets.memento-cloud.fr/Korus-Docker-Latest.tar.gz --output Korus-Docker-Latest.tar.gz
# tar -xz -f Korus-Docker-Latest.tar.gz
# ./install.py


import json
import subprocess
import sys
from pathlib import Path


class BColors:
	HEADER = '\033[95m'
	OKGREEN = '\033[92m'
	WARNING = '\033[93m'
	FAIL = '\033[91m'
	ENDC = '\033[0m'
	BOLD = '\033[1m'


def pTitre(iStr: str):
	print(f"{BColors.HEADER}{iStr}{BColors.ENDC}")


def pSubtitre(iStr: str):
	print(f"{BColors.BOLD}{iStr}{BColors.ENDC}")


def pSucces(iStr: str):
	print(f"{BColors.OKGREEN}{iStr}{BColors.ENDC}")


def pWarning(iStr: str):
	print(f"{BColors.WARNING}{iStr}{BColors.ENDC}")


def pFail(iStr: str):
	print(f"{BColors.FAIL}{iStr}{BColors.ENDC}")


def execCmd(iCmd: str, *args, iPrint: bool = True, **kwargs):
	if iPrint:
		print(iCmd)
	subprocess.run(iCmd, *args, check=True, executable="bash", shell=True, **kwargs)


kNomImage = "memento-cloud.fr/korus-install:latest"

pTitre(
"""
===================================================================
= Bienvenue dans la configuration de Korus pour plateforme Docker =
===================================================================
""")

print("Ce script configurera le dossier courant pour acceuillir une installation du logiciel de sauvegarde Korus via Docker.")
print("Si le dossier courant n'est pas adéquat, merci de créer un nouveau dossier et de copier les éléments de l'installateur dedans.")
print("En cas d'erreur, vous pouvez terminer le script avec 'CTRL + C' et le lancer à nouveau.")

pTitre(
"""
------------------------------------------
- ETAPE 1/3" :  Import de l'image Docker -
------------------------------------------
""")
pWarning("Il vous sera peut être demandé de fournir votre mdp sudo.")
lCmd = f"sudo echo 'Import en cours...' && cat ./Korus-Docker-*.img | sudo docker load"
execCmd(lCmd)

pSucces("Import de l'image terminé avec succès.")


pTitre(
"""
--------------------------------------------------------------------------
- ETAPE 2/3" : Création d'un volume pour stocker les données de l'agent. -
--------------------------------------------------------------------------
""")

lVol = Path("./volume")
lVol.mkdir(exist_ok=True)

pSucces("Volume créé avec succès.")


pTitre(
"""
-------------------------------------------
- ETAPE 3/3" : Configuration du conteneur -
-------------------------------------------
""")

pSubtitre("3.1 : Veuillez indiquer le nom de l'agent (utilisé pour identifier le conteneur) : ")
lNomAgent = input()

pSubtitre("3.2 : Veuillez copiez-coller le jeton d'installation : ")
lJeton = input()

pSubtitre("3.3 : Indiquez le chemin vers le fichier Trousseau.html (ou laissez vide pour utiliser un nouveau trousseau) : ")
lTrousseau = input()
lDestTrousseau = lVol / "Trousseau.html"
if lTrousseau:
	lCheminT = Path(lTrousseau)
	if not lCheminT.is_file():
		pFail(f"ERREUR : le fichier {lCheminT.as_posix()} n'existe pas. Abandon de la configuration.")
		sys.exit(1)
	execCmd(f"sudo rm -f '{lDestTrousseau.as_posix()}'")
	lDestTrousseau.write_text(lCheminT.read_text())
	execCmd(f"sudo chmod 600 '{lDestTrousseau.as_posix()}' && sudo chown root:root '{lDestTrousseau.as_posix()}'")
	pSucces("Configuration du Trousseau terminée avec succès: utilisation d'un Trousseau existant.")
else:
	execCmd(f"sudo rm -f '{lDestTrousseau.as_posix()}'", iPrint=False)
	pSucces("Configuration du Trousseau terminée avec succès: génération d'un nouveau Trousseau.")

lDockerCompose: dict = json.loads(Path("./template-docker-compose.yml").read_text())
pSubtitre("3.4 : Voulez vous réaliser des sauvegardes depuis ce conteneur ? (O/N) ")
lModeSav = input()
lCheminVolHote = ""
if lModeSav == "O":
	pSubtitre("3.4 : Veuillez indiquer le chemin à monter dans le conteneur (par exemple '/home'):")
	lCheminVolHote = input()
	lDockerCompose["services"]["korus"]["volumes"].append(
		{
			"type": "bind",
			"source": "${HOST_VOLUME_PATH}",
			"target": "/memento/host_root",
			"consistency": "consistent"
		}
	)
	pSucces("Configuration du volume hôte terminée avec succès: la sauvegarde de l'hôte sera possible.")
else:
	pWarning("Attention : le conteneur n'aura pas accès au système hôte et ne pourra pas sauvegarder de donnée.")

Path("./docker-compose.yml").write_text(json.dumps(lDockerCompose, indent=4, sort_keys=True), encoding="utf-8")

pSubtitre("3.5 : Création des fichiers de configuration.")
lENV = f"NOM_KORUS={lNomAgent}\n"
lENV += "CHEM_VOL_STOCKAGE=./volume\n"
lENV += f"NOM_IMAGE={kNomImage}\n"
lENV += f"HOST_VOLUME_PATH={lCheminVolHote}\n" if lCheminVolHote else ""

Path(".env").write_text(lENV)

lKorusEnv = f"MEMENTO_JETON_LIAISON={lJeton}\n"
Path("korus.env").write_text(lKorusEnv)

pSucces("Fichiers de configuration créés avec succès.")

pTitre(
"""
-------------------------
- Installation Terminée -
-------------------------
""")
print("Vous pouvez controler l'agent avec les commandes suivantes (exécutées depuis ce dossier) :")
print("Lancement : 'sudo docker-compose --compatibility up --detach'")
print("Arrêt :     'sudo docker-compose --compatibility down'")
